var updateInterval;
var selectedIndex = -1;
var airportEnabled = true;
var offset = 0;
var totalNetworks = 0;

var updateTimer = 3000;
var compareMethod = "channel";

var stretcher;

var networkList = new Array();

var nameForSetNetwork; 
var encryptionForSetNetwork; 
var messageForSetNetwork; 

var hasExtreme = false;

/***************************************************/
// Widget Update Methods
/***************************************************/

if(window.widget){
	widget.onshow = onshow;
	widget.onhide = onhide;
	widget.onremove = onremove;
}

onshow();

function onshow(){
	if(updateInterval == null)
		updateInterval = setInterval("update();", updateTimer);
}

function onhide(){
	if(updateInterval != null){
		clearInterval(updateInterval);
		updateInterval = null;
	}
}

function onremove ()
{
		if(updateInterval != null){
			clearInterval(updateInterval);
		updateInterval = null;
	}
		widget.setPreferenceForKey (null, widget.identifier);
}

function init(){;
	readPrefsFromFile();
	createStretcher();
	checkForAirPortVersion();
	intitUpdate();
}



function update(){	
	if(window.AirPort){
		AirPort.scan(stretcher.isStretched());
		// Wait a second to make sure that the data has been updated by the thread
		setTimeout ('updateAirPortAfterScan();', 250);

	}
	else{
		document.getElementById('signal_image').src = "images/signaloff.png";
	}
}

function intitUpdate(){	
	if(window.AirPort){
		AirPort.scan(true);
		// Wait a second to make sure that the data has been updated by the thread
		setTimeout ('updateAirPortAfterScan();', 1000);

	}
	else{
		document.getElementById('signal_image').src = "images/signaloff.png";
	}
}

function updateAirPortAfterScan(){
		if(updateCurrentStatus(AirPort.currentStatus()) && stretcher.isStretched()){
			updateNetworkList(AirPort.networkList(), AirPort.currentStatus());
		}
}


function updateCurrentStatus(array){
		// We are actually connected to a network
		if(array != null && array[4]!="444444" && array[4]!="000000" && array[0] !="" ){
			//alert(array);
			var encryptionText = array[1]
			
			//nameText = "0123456789012";
			var nameText = array[0];
			
			if(nameText.length > 12){
				nameText = nameText.substr(0, 10)+"...";
			}
			
			//vendorText = "01234567890123";
			var vendorText = array[4];
			if(vendorText.length > 13){
				vendorText = vendorText.substr(0, 12)+"...";
			}
				
			document.getElementById('network_name').innerText = nameText;
			document.getElementById('network_vendor').innerText = vendorText;
			document.getElementById('network_encyption').innerText = encryptionText;
			document.getElementById('network_speed').innerText = array[3]+" Mbps";
			if(array.length >=7 && array[6] != null)
			document.getElementById('network_channel').innerText = array[6];
			//document.getElementById('network_name').innerText = array[5];
			var signalStrength = array[5];
			//alert("signal: "+signalStrength);
			
			if(signalStrength >= 60){
				document.getElementById('signal_image').src = "images/signal5.png";
			}
			else if(signalStrength >= 40){
				document.getElementById('signal_image').src = "images/signal4.png";
			}
			else if(signalStrength >= 30){
				document.getElementById('signal_image').src = "images/signal3.png";
			}
			else if(signalStrength >= 20){
				document.getElementById('signal_image').src = "images/signal2.png";
			}
			else if(signalStrength > 0){
				document.getElementById('signal_image').src = "images/signal1.png";
			}
			else{
				document.getElementById('signal_image').src = "images/signal0.png";
			}
			
			
			document.getElementById('signal_image').setAttribute("onClick", "");
			document.getElementById('front_top').setAttribute("onClick", "stretcher.stretch(event);");
			
			return true;
		   
		 }
		 //Airport is either off or not connected to a network.
		else if(array != null && AirPort.powerOn() && AirPort.enabled()){
			//alert(array);
			document.getElementById('network_name').innerText = "Disconnected.";
			document.getElementById('network_vendor').innerText = "No Information.";
			document.getElementById('network_encyption').innerText = "";
			document.getElementById('network_speed').innerText = "0 Mbps";
			document.getElementById('network_channel').innerText = "";
			document.getElementById('signal_image').src = "images/signaloff.png";
			
			document.getElementById('signal_image').setAttribute("onClick", "");
			document.getElementById('front_top').setAttribute("onClick", "stretcher.stretch(event);");
			return true;
		}
		 //Airport is either off or not connected to a network.
		else if(array != null && !AirPort.powerOn()){
			//alert(array);
			document.getElementById('network_name').innerHTML = "<span class=\"power_on\" onClick=\"AirPort.setPower(true)\">Turn Power On</span>";
			document.getElementById('network_vendor').innerText = "AirPort is off.";
			document.getElementById('network_encyption').innerText = "";
			document.getElementById('network_speed').innerText = "0 Mbps";
			document.getElementById('network_channel').innerText = "";
			document.getElementById('signal_image').src = "images/signaloff.png";
			
			document.getElementById('signal_image').setAttribute("onCLick", "AirPort.setPower(true);");
			document.getElementById('front_top').setAttribute("onClick", "");
			
			if(stretcher.isStretched()){
				stretcher.stretch(null);						 
			}
			
			return true;
		}
		// There is likely no AirPort card in this computer.
		else{
			//alert(array);
			document.getElementById('network_name').innerText = "N/A";
			document.getElementById('network_vendor').innerText = "No AirPort.";
			document.getElementById('network_encyption').innerText = "";
			document.getElementById('network_speed').innerText = "0 Mbps";
			document.getElementById('network_channel').innerText = "";
			document.getElementById('signal_image').src = "images/no_signal.png";
			
				document.getElementById('signal_image').setAttribute("onClick", "");
			document.getElementById('front_top').setAttribute("onClick", "");
			
			if(stretcher.isStretched()){
				stretcher.stretch(null);						 
			}
			
			return false;
		}	
	
}

function updateNetworkList(array, currentNetworkArray){
	var networkDetailArray;
	var networkDetails;
	var htmlToAdd = "";
	var index;
	var found;
	var count = 0;
	
	//set the visible to false - after update it will be true again - this lets us know if we can see the network
	for(index = 0; index < networkList.length; index++){
			networkList[index].visible = false;
			networkList[index].signal = 0;
			networkList[index].connected = false;
	}
	
	if(array != null){
		for(var i=0; i<array.length; i++){
			networkDetailArray = array[i];
			if(networkDetailArray != null && networkDetailArray.length >= 6){
				networkDetails = new WirelessNetwork(networkDetailArray[1]);
				networkDetails.UpdateFromArray(networkDetailArray);
				
				found = false;
				
				for(index = 0; index < networkList.length; index++){
					if(networkList[index].macAddress == networkDetails.macAddress){
						networkList[index].UpdateFromArray(networkDetailArray);
						if(currentNetworkArray[2] == networkDetails.macAddress)
							networkList[index].connected = true;
						//alert("found network in list"+currentNetworkArray[2]+" "+ networkDetails.macAddress);	
						found = true;
					}
				}
				
				if(!found){
					networkDetails.UpdateFromArray(networkDetailArray);
					networkList.push(networkDetails)
					//alert("added network to list: "+networkDetails.name);
				}
								
			}
		}
		
		
	}
	
	
	//alert(networkList);
	
	if(compareMethod == "signal")
		networkList.sort(compareSignal);
	else if(compareMethod == "channel")
		networkList.sort(compareChannel);
	else if(compareMethod == "encyption")
		networkList.sort(compareEncryption);
	else if(compareMethod == "name")
		networkList.sort(compareName);
	else if(compareMethod == "vendor")
		networkList.sort(compareVendor);
	else
		networkList.sort(compareSignal);
	
	for(var i=0; i<networkList.length; i++){
		if( networkList[i].Refresh() ){
			count ++;
			htmlToAdd += networkList[i].toHTMLString(hasExtreme) ;
		}
	}
	
	document.getElementById('network_list').innerHTML = htmlToAdd;
	
	if(count > 7)	
		stretcher.updateSize(140 + (count - 7) * 16 );
	else
		stretcher.updateSize(140);
}


//********* COMPARISON FUCTIONS FOR SORTING THE NETWORK LIST ****************//

function compareSignal(a,b){
	return b.signal - a.signal;
}

function compareChannel(a,b){
	return a.channel - b.channel;	
}

function compareEncryption(b,a){
	if(a.encryption.toLowerCase() > b.encryption.toLowerCase())
		return 1;
	else if(a.encryption.toLowerCase() < b.encryption.toLowerCase())
		return -1;
	else
		return a.signal - b.signal;;
}

function compareName(a,b){
	if(a.name.toLowerCase() > b.name.toLowerCase())
		return 1;
	else if(a.name.toLowerCase() < b.name.toLowerCase())
		return -1;
	else
		return 0;
}

function compareVendor(a,b){
	if(a.vendor.toLowerCase() > b.vendor.toLowerCase())
		return 1;
	else if(a.vendor.toLowerCase() < b.vendor.toLowerCase())
		return -1;
	else if(a.name.toLowerCase() > b.name.toLowerCase())
		return 1;
	else if(a.name.toLowerCase() < b.name.toLowerCase())
		return -1;
	else
		return 0;
}



function connectToNetwork(name, encryption, message){
	document.getElementById('front_cover').style.display = 'block';
	document.getElementById('front_cover_text').innerText = "Connecting to Network.";
	document.getElementById('front_cover_text').style.color = "#66FF33";
	nameForSetNetwork = name;
	encryptionForSetNetwork = encryption;
	messageForSetNetwork = message;

	if(!message){
		setTimeout ("connect_delayed(nameForSetNetwork, encryptionForSetNetwork, messageForSetNetwork);", 100);
	}
	else{
		displayPasswordInput(name, encryption, message);
	}
	
}

function connect_delayed(name, encryption, message){
	var password = AirPort.getPasswordForNetwork(name);
	document.getElementById('front_cover').style.display = 'block';
	
	
	// NO ENCRYPTION
	if(encryption == "none" || encryption.length < 2){
		AirPort.connect(name);
		hideConnectingMessage();
	}
	//ENCRYPTED - need to get password
	else{
					
		if( (password!= null && encryption == "WPA") || (password!= null && encryption == "WPA2")){
			if(!AirPort.connectWPA(name, password)){
				displayPasswordInput(name, encryption, true);
			}
			else
				hideConnectingMessage();
		}
		else if(password!= null && encryption == "WEP"){
			if(!AirPort.connectWEP(name, password)){
				displayPasswordInput(name, encryption, true);
			}
			else
				hideConnectingMessage();
		}
		else
			displayPasswordInput(name, encryption, false);
	}
	
}

function cancel_connect(){
	hidedPasswordInput();	
	document.getElementById('front_cover').style.display = 'none';
}

function accept_connect(name, encryption){
	
	document.getElementById('error_message_text').style.display = 'block';
	document.getElementById('error_message_text').innerHTML = "<span id=\"trying_connect\">Trying to connect with your key.</span>" ;
	
	nameForSetNetwork = name;
	encryptionForSetNetwork = encryption;
	messageForSetNetwork = false;
	
	setTimeout ("accept_connect_delayed(nameForSetNetwork, encryptionForSetNetwork);", 100);
}

function accept_connect_delayed(name, encryption){
	var password = document.getElementById('key_input').value;
	document.getElementById('key_input').value = "";
	document.getElementById('front_cover').style.display = 'block';

	if(encryption == "WEP" && AirPort.connectWEP(name, "0x"+password)){
		//alert("WEP + SUCCESS");
		AirPort.storePassword("0x" + password.toUpperCase(), name);
		hidedPasswordInput();
		hideConnectingMessage();
	}
	else if(AirPort.connectWPA(name, password)){
		//alert("WPA + SUCCESS");
		AirPort.storePassword(password, name);
		hidedPasswordInput();
		hideConnectingMessage();
	}
	else{
		//alert(encryption+ " + FAILED");
		displayPasswordInput(name, encryption, true);
	}
}


function hideConnectingMessage(){
	setTimeout ("document.getElementById('front_cover').style.display = 'none';", updateTimer-500);
}


function displayPasswordInput(name, encryption, message){
	document.getElementById('front_center_cover').style.height = stretcher.maxPosition-68+"px";
	document.getElementById('front_center_cover').style.display = 'block';
	document.getElementById('network_name_text').innerHTML = "&quot;"+name+"&quot; requires a "+encryption+" key that is not in your keychain.<br/>";
	document.getElementById('accept_image').setAttribute("onClick","accept_connect('"+name+"','"+encryption+"');");
	
	if(message == true){
		document.getElementById('error_message_text').style.display = 'block';
		document.getElementById('error_message_text').innerHTML = "Your key was rejected by the network!" ;
	}
	else{
		document.getElementById('error_message_text').style.display = 'none';
	}
	
}

function displayNoPassword(name, encryption){
	document.getElementById('front_center_cover').style.height = stretcher.maxPosition-68+"px";
	document.getElementById('front_center_cover').style.display = 'block';
	document.getElementById('network_name_text').innerHTML = "&quot;"+name+"&quot; requires a "+encryption+" key that cannot be set from AirTrafficControl.<br/>";
	document.getElementById('accept_image').setAttribute("onClick","");
	document.getElementById('accept_image').setAttribute("onMouseDown","");
	document.getElementById('accept_image').setAttribute("onMouseUp","");
	document.getElementById('accept_image').setAttribute("onMouseOut","");
	document.getElementById('accept_image').src="images/check_circle_disabled.png";
	document.getElementById('network_key_text').style.display = 'none';
	document.getElementById('network_key_text').style.cursor = 'auto';
	
	
	document.getElementById('front_cover_text').innerText = "Can't Connect to Network.";
	document.getElementById('front_cover_text').style.color = "#FF6600";
	
	
	
	document.getElementById('error_message_text').style.display = 'block';
	document.getElementById('error_message_text').innerText = "AirPort Extreme is required.";
	document.getElementById('network_key_input').style.display = 'none';
	
	
	
}


function hidedPasswordInput(){
	setTimeout ("document.getElementById('front_center_cover').style.display = 'none';",100);
}


/***************************************************/
// Strecher Stuff
/***************************************************/

function stretching(){	
	//alert("done");
	if(! stretcher.isStretched()){
		document.getElementById('front_bottom_image').src = "images/front_bottom.png";
	}
	else{
		document.getElementById('front_bottom_image').src = "images/front_bottom_closed.png";
	}
}

function stretched(){
	
}


function createStretcher(){
	stretcher = new Stretcher(document.getElementById('front'), 140, 140, 250, stretching, stretched);
}

/***************************************************/
// Service Methods
/***************************************************/

function turnAirportOn(){
	if(window.widget && window.AirPort){
		//airportEnabled = AirPort.logMessage("cool");
	}
}

function shortName(name){
	if(name.length > 13)
		return name.substr(0,11)+"...";
	else
		return name;
}




/***************************************************/
// Other Methods
/***************************************************/


function gotoST(){
	if(window.widget){
		widget.openURL("http://www.spintriplet.com");
	}
}

function gotoSupport(){
	if(window.widget){
		widget.openURL("http://www.spintriplet.com/atc/support.php");
	}
}


function gotoUpdate(){
	if(window.widget){
		widget.openURL("http://www.spintriplet.com/atc/update.php");
	}
}

function checkForUpdates(){
	var updatesForProgram = false;
	var updatesForVendors = false;
	
	document.getElementById('check_update_text').innerHTML = "Checking for updates...";
	document.getElementById('check_updates_reponse').style.display = 'table-row';
	
	setTimeout ("checkForUpdatesWithDelay();", 100);

}

function checkForUpdatesWithDelay(){
	var updatesForProgram = false;
	var updatesForVendors = false;

	if(window.widget && window.AirPort){
		updatesForProgram = AirPort.updateAvailable();
		updatesForVendors = AirPort.vendorUpdateAvailable();
		
		if(updatesForProgram || updatesForVendors)
			document.getElementById('check_updates_row').style.display = 'none';
		else
			document.getElementById('check_updates_row').style.display = 'table-row';
		
		if(!updatesForProgram && !updatesForVendors){
			document.getElementById('check_updates_reponse').style.display = 'table-row';
			document.getElementById('check_update_text').innerHTML="No updates available.";
		}
		else{
			document.getElementById('check_updates_reponse').style.display = 'none';
			document.getElementById('check_update_text').innerText="";
		}
			
			
		if(updatesForProgram){
			document.getElementById('download_update_row').style.display = 'table-row';
			document.getElementById('update_list_row').style.display = 'none';
		}
		else if(updatesForVendors)	{
			document.getElementById('update_list_row').style.display = 'table-row';
			document.getElementById('download_update_row').style.display = 'none';
		}
		else{
			document.getElementById('download_update_row').style.display = 'none';
			document.getElementById('update_list_row').style.display = 'none';
		}
			

			
	}

}



function cleanUpBack(){

		document.getElementById('check_update_text').innerHTML="&nbsp;";
		document.getElementById('vendor_update_text').innerHTML="&nbsp;";
		document.getElementById('check_updates_row').style.display = 'table-row';
		document.getElementById('check_updates_reponse').style.display = 'none';
		document.getElementById('update_list_row').style.display = 'none';
		document.getElementById('download_update_row').style.display = 'none';
		document.getElementById('vendor_update_reponse').style.display = 'none';
}

function updateVendorList(){
	if(window.widget && window.AirPort){
		document.getElementById('vendor_update_text').innerHTML = "Updating vendor list...";
		document.getElementById('vendor_update_reponse').style.display = 'table-row';
	
		setTimeout ("updateVendorListWithDelay();", 100);
		
	}
			
}

function updateVendorListWithDelay(){
			
		if(AirPort.updateVendors()){
			document.getElementById('update_list_row').style.display = 'none';
			document.getElementById('vendor_update_text').innerHTML = "Vendor update complete.";
		}
		else{
			document.getElementById('update_list_row').style.display = 'table-row';
			document.getElementById('vendor_update_text').innerHTML = "Vendor update failed. Try again later.";
		}
}

//

function checkForAirPortVersion(){	
	if(window.widget && window.widget.system){
		var apVersion = widget.system("system_profiler SPAirPortDataType | grep \"Wireless Card Type:\"", null);
		
		if(apVersion.outputString.indexOf("Extreme") > 0){
			hasExtreme = true;
		}
		else{
			hasExtreme = false;
		}
		
	}

}


//
function updatePrefs(elem){
	var selection;
	
	if(window.widget){
		if(elem == "sort_select"){
			selection = document.getElementById('sort_select');
			compareMethod = selection.options[selection.selectedIndex].value;
		}
		else if(elem == "update_select"){
			selection = document.getElementById('update_select');
			updateTimer = selection.options[selection.selectedIndex].value;
			
		}
		else
			return;
			
		widget.setPreferenceForKey (compareMethod, "compareMethod");
		widget.setPreferenceForKey (updateTimer, "updateTimer");
		
		readPrefsFromFile();
		
		if(updateInterval != null){
			clearInterval(updateInterval);
			updateInterval = setInterval("update();", updateTimer);
		}
		else{
			updateInterval = setInterval("update();", updateTimer);
		}
	}
	
}

//
function readPrefsFromFile(){
	var localCompareMethod;
	var localUpdateTimer;
	
	if(window.widget){
		localCompareMethod = widget.preferenceForKey("compareMethod");
		if(localCompareMethod != null && localCompareMethod!="")
			compareMethod = localCompareMethod;
			
		localUpdateTimer = widget.preferenceForKey ("updateTimer");	
		if(localUpdateTimer != null && localUpdateTimer != "")
			updateTimer = localUpdateTimer;
			
		
		//alert(localUpdateTimer +" - "+  localCompareMethod);

	}
	
}

function setSelection(){
	var selection;
	
	selection = document.getElementById('sort_select');
	for(var i=0; i< selection.options.length; i++){
		if(	compareMethod == selection.options[i].value){
			selection.selectedIndex = i;
			selection.options[i].selected = true;
		}
	}
	
	selection = document.getElementById('update_select');
	for(var i=0; i< selection.options.length; i++){
		if(	updateTimer == selection.options[i].value){
			selection.selectedIndex = i;
			selection.options[i].selected = true;
		}
	}
	
}

/***************************************************/
// HIDING AND SHOWING PREFERENCES - THANKS TO APPLE
/***************************************************/

// showPrefs() is called when the preferences flipper is clicked upon.  It freezes the front of the widget,
// hides the front div, unhides the back div, and then flips the widget over.

function showPrefs()
{
	var front = document.getElementById("front");
	var back = document.getElementById("back");
	
	document.getElementById("back_title_text").innerText = "AirTrafficControl v"+AirPort.getWidgetVersion();
	
	setSelection();
	
	if (window.widget)
		widget.prepareForTransition("ToBack");		// freezes the widget so that you can change it without the user noticing
	
	front.style.display="none";		// hide the front
	back.style.display="block";		// show the back
	
	
	
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);		// and flip the widget over	

	document.getElementById('fliprollie').style.display = 'none';  // clean up the front side - hide the circle behind the info button

}


// hidePrefs() is called by the done button on the back side of the widget.  It performs the opposite transition
// as showPrefs() does.

function hidePrefs()
{
	
	var done = document.getElementById("done_button");
	done.src='images/done.png';

	var front = document.getElementById("front");
	var back = document.getElementById("back");
	
	
	
	if (window.widget)
		widget.prepareForTransition("ToFront");		// freezes the widget and prepares it for the flip back to the front
	
	cleanUpBack();
	back.style.display="none";			// hide the back
	front.style.display="block";		// show the front
	
	
	
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);		// and flip the widget back to the front
}


// PREFERENCE BUTTON ANIMATION (- the pref flipper fade in/out)

var flipShown = false;		// a flag used to signify if the flipper is currently shown or not.


// A structure that holds information that is needed for the animation to run.
var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, firstElement:null, timer:null};


// mousemove() is the event handle assigned to the onmousemove property on the front div of the widget. 
// It is triggered whenever a mouse is moved within the bounds of your widget.  It prepares the
// preference flipper fade and then calls animate() to performs the animation.

function mousemove (event)
{
	if (!flipShown)			// if the preferences flipper is not already showing...
	{
		if (animation.timer != null)			// reset the animation timer value, in case a value was left behind
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13; 							// set it back one frame
		
		animation.duration = 500;												// animation time, in ms
		animation.starttime = starttime;										// specify the start time
		animation.firstElement = document.getElementById ('flip');				// specify the element to fade
		animation.timer = setInterval ("animate();", 13);						// set the animation function
		animation.from = animation.now;											// beginning opacity (not ness. 0)
		animation.to = 1.0;														// final opacity
		animate();																// begin animation
		flipShown = true;														// mark the flipper as animated
	}
}

// mouseexit() is the opposite of mousemove() in that it preps the preferences flipper
// to disappear.  It adds the appropriate values to the animation data structure and sets the animation in motion.

function mouseexit (event)
{
	if (flipShown)
	{
		// fade in the flip widget
		if (animation.timer != null)
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13;
		
		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById ('flip');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 0.0;
		animate();
		flipShown = false;
	}
}


// animate() performs the fade animation for the preferences flipper. It uses the opacity CSS property to simulate a fade.

function animate()
{
	var T;
	var ease;
	var time = (new Date).getTime();
		
	
	T = limit_3(time-animation.starttime, 0, animation.duration);
	
	if (T >= animation.duration)
	{
		clearInterval (animation.timer);
		animation.timer = null;
		animation.now = animation.to;
	}
	else
	{
		ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
		animation.now = computeNextFloat (animation.from, animation.to, ease);
	}
	
	animation.firstElement.style.opacity = animation.now;
}


// these functions are utilities used by animate()

function limit_3 (a, b, c)
{
    return a < b ? b : (a > c ? c : a);
}

function computeNextFloat (from, to, ease)
{
    return from + (to - from) * ease;
}

// these functions are called when the info button itself receives onmouseover and onmouseout events

function enterflip(event)
{
	document.getElementById('fliprollie').style.display = 'block';
}

function exitflip(event)
{
	document.getElementById('fliprollie').style.display = 'none';
}

